/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.utils;

import io.izzel.arclight.api.Unsafe;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.magmafoundation.magma.common.utils.JarTool;
import org.magmafoundation.magma.common.utils.SystemType;

public class ServerInitHelper {
    private static final MethodHandles.Lookup IMPL_LOOKUP = Unsafe.lookup();
    private static final List<String> OPENS = new ArrayList<String>();
    private static final List<String> EXPORTS = new ArrayList<String>();
    private static String MODULE_PATH = null;

    public static void init(List<String> args) {
        EXPORTS.add("cpw.mods.securejarhandler/cpw.mods.niofs.union=ALL-UNNAMED");
        EXPORTS.add("cpw.mods.securejarhandler/cpw.mods.jarhandling=ALL-UNNAMED");
        String libsPath = JarTool.getJarDir() + File.separator + "libraries" + File.separator;
        StringBuilder modulePath = new StringBuilder();
        ((Stream)args.parallelStream().parallel()).forEach(arg -> {
            if (arg.startsWith("-p ")) {
                String[] split;
                MODULE_PATH = arg.substring(2).trim();
                for (String s : split = MODULE_PATH.split(File.pathSeparator)) {
                    if (!s.startsWith("libraries/")) continue;
                    modulePath.append(libsPath).append(s.substring("libraries/".length() - 1)).append(File.pathSeparator);
                }
            } else if (arg.startsWith("--add-opens ")) {
                OPENS.add(arg.substring("--add-opens ".length()).trim());
            } else if (arg.startsWith("--add-exports ")) {
                EXPORTS.add(arg.substring("--add-exports ".length()).trim());
            } else if (arg.startsWith("-D")) {
                String[] params = arg.substring(2).split("=", 2);
                if (params[0].equals("legacyClassPath")) {
                    String[] split = params[1].split(File.pathSeparator);
                    StringBuilder tmp = new StringBuilder();
                    for (String s : split) {
                        if (s.startsWith("libraries/com/mojang/brigadier") || !s.startsWith("libraries/")) continue;
                        tmp.append(libsPath).append(s.substring("libraries/".length() - 1)).append(File.pathSeparator);
                    }
                    System.setProperty(params[0], tmp.toString());
                } else if (params[0].equals("libraryDirectory")) {
                    System.setProperty(params[0], libsPath);
                } else {
                    System.setProperty(params[0], params[1]);
                }
            }
        });
        MODULE_PATH = modulePath.toString();
        try {
            ServerInitHelper.loadModules(MODULE_PATH);
            Thread.sleep(500L);
            ServerInitHelper.addOpens(OPENS);
            ServerInitHelper.addExports(EXPORTS);
            Thread.sleep(500L);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void addToPath(Path path) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Field ucpField;
            try {
                ucpField = loader.getClass().getDeclaredField("ucp");
            }
            catch (NoSuchFieldException e) {
                ucpField = loader.getClass().getSuperclass().getDeclaredField("ucp");
            }
            long offset = Unsafe.objectFieldOffset(ucpField);
            Object ucp = Unsafe.getObject(loader, offset);
            if (ucp == null) {
                Class<?> cl = Class.forName("jdk.internal.loader.URLClassPath");
                MethodHandle handle = Unsafe.lookup().findConstructor(cl, MethodType.methodType(Void.TYPE, URL[].class, AccessControlContext.class));
                ucp = handle.invoke(new URL[0], null);
                Unsafe.putObjectVolatile(loader, offset, ucp);
            }
            Method method = ucp.getClass().getDeclaredMethod("addURL", URL.class);
            Unsafe.lookup().unreflect(method).invoke(ucp, path.toUri().toURL());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void agentmain(String a, Instrumentation inst) {
    }

    public static void premain(String agentArgs, Instrumentation inst) {
    }

    public static void addExports(String module, String pkg, String target) {
        if (target == null) {
            target = "ALL-UNNAMED";
        }
        try {
            ServerInitHelper.addExports(List.of(module + "/" + pkg + "=" + target));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void addExports(List<String> exports) throws Throwable {
        MethodHandle implAddExportsMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddExports", MethodType.methodType(Void.TYPE, String.class, Module.class));
        MethodHandle implAddExportsToAllUnnamedMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddExportsToAllUnnamed", MethodType.methodType(Void.TYPE, String.class));
        ServerInitHelper.addExtra(exports, implAddExportsMH, implAddExportsToAllUnnamedMH);
    }

    public static void addOpens(String module, String pkg, String target) {
        if (target == null) {
            target = "ALL-UNNAMED";
        }
        try {
            ServerInitHelper.addOpens(List.of(module + "/" + pkg + "=" + target));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void addOpens(List<String> opens) throws Throwable {
        MethodHandle implAddOpensMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddOpens", MethodType.methodType(Void.TYPE, String.class, Module.class));
        MethodHandle implAddOpensToAllUnnamedMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddOpensToAllUnnamed", MethodType.methodType(Void.TYPE, String.class));
        ServerInitHelper.addExtra(opens, implAddOpensMH, implAddOpensToAllUnnamedMH);
    }

    private static ParserData parseModuleExtra(String extra) {
        String[] all = extra.split("=", 2);
        if (all.length < 2) {
            return null;
        }
        String[] source = all[0].split("/", 2);
        if (source.length < 2) {
            return null;
        }
        return new ParserData(source[0], source[1], all[1]);
    }

    private static void addExtra(List<String> extras, MethodHandle implAddExtraMH, MethodHandle implAddExtraToAllUnnamedMH) {
        ((Stream)extras.parallelStream().parallel()).forEach(extra -> {
            ParserData data = ServerInitHelper.parseModuleExtra(extra);
            if (data != null) {
                ModuleLayer.boot().findModule(data.module).ifPresent(m -> {
                    try {
                        if ("ALL-UNNAMED".equals(data.target)) {
                            implAddExtraToAllUnnamedMH.invokeWithArguments(m, data.packages);
                        } else {
                            ModuleLayer.boot().findModule(data.target).ifPresent(tm -> {
                                try {
                                    implAddExtraMH.invokeWithArguments(m, data.packages, tm);
                                }
                                catch (Throwable t) {
                                    throw new RuntimeException(t);
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                });
            }
        });
    }

    private static void loadModules(String modulePath) throws Throwable {
        ModuleFinder finder = ModuleFinder.of((Path[])Arrays.stream(modulePath.split(SystemType.getOS() == SystemType.OS.WINDOWS ? ";" : ":")).map(x$0 -> Paths.get(x$0, new String[0])).peek(ServerInitHelper::addToPath).toArray(Path[]::new));
        MethodHandle loadModuleMH = IMPL_LOOKUP.findVirtual(Class.forName("jdk.internal.loader.BuiltinClassLoader"), "loadModule", MethodType.methodType(Void.TYPE, ModuleReference.class));
        Configuration config = Configuration.resolveAndBind(finder, List.of(ModuleLayer.boot().configuration()), finder, finder.findAll().stream().peek(mref -> {
            try {
                loadModuleMH.invokeWithArguments(Thread.currentThread().getContextClassLoader(), mref);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }).map(ModuleReference::descriptor).map(ModuleDescriptor::name).collect(Collectors.toList()));
        MethodHandle graphGetter = IMPL_LOOKUP.findGetter(Configuration.class, "graph", Map.class);
        HashMap<ResolvedModule, Set> graphMap = new HashMap<ResolvedModule, Set>((Map)graphGetter.invokeWithArguments(config));
        MethodHandle cfSetter = IMPL_LOOKUP.findSetter(ResolvedModule.class, "cf", Configuration.class);
        graphMap.forEach((k, v) -> {
            try {
                cfSetter.invokeWithArguments(k, ModuleLayer.boot().configuration());
                v.forEach(m -> {
                    try {
                        cfSetter.invokeWithArguments(m, ModuleLayer.boot().configuration());
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        graphMap.putAll((Map)graphGetter.invokeWithArguments(ModuleLayer.boot().configuration()));
        IMPL_LOOKUP.findSetter(Configuration.class, "graph", Map.class).invokeWithArguments(ModuleLayer.boot().configuration(), new HashMap(graphMap));
        Set<ResolvedModule> oldBootModules = ModuleLayer.boot().configuration().modules();
        MethodHandle modulesSetter = IMPL_LOOKUP.findSetter(Configuration.class, "modules", Set.class);
        HashSet<ResolvedModule> modulesSet = new HashSet<ResolvedModule>(config.modules());
        modulesSetter.invokeWithArguments(ModuleLayer.boot().configuration(), new HashSet<ResolvedModule>(modulesSet));
        MethodHandle nameToModuleGetter = IMPL_LOOKUP.findGetter(Configuration.class, "nameToModule", Map.class);
        HashMap nameToModuleMap = new HashMap((Map)nameToModuleGetter.invokeWithArguments(ModuleLayer.boot().configuration()));
        nameToModuleMap.putAll((Map)nameToModuleGetter.invokeWithArguments(config));
        IMPL_LOOKUP.findSetter(Configuration.class, "nameToModule", Map.class).invokeWithArguments(ModuleLayer.boot().configuration(), new HashMap(nameToModuleMap));
        ((Map)IMPL_LOOKUP.findGetter(ModuleLayer.class, "nameToModule", Map.class).invokeWithArguments(ModuleLayer.boot())).putAll((Map)IMPL_LOOKUP.findStatic(Module.class, "defineModules", MethodType.methodType(Map.class, Configuration.class, Function.class, ModuleLayer.class)).invokeWithArguments(ModuleLayer.boot().configuration(), name -> Thread.currentThread().getContextClassLoader(), ModuleLayer.boot()));
        modulesSet.addAll(oldBootModules);
        modulesSetter.invokeWithArguments(ModuleLayer.boot().configuration(), new HashSet<ResolvedModule>(modulesSet));
        IMPL_LOOKUP.findSetter(ModuleLayer.class, "modules", Set.class).invokeWithArguments(ModuleLayer.boot(), null);
        IMPL_LOOKUP.findSetter(ModuleLayer.class, "servicesCatalog", Class.forName("jdk.internal.module.ServicesCatalog")).invokeWithArguments(ModuleLayer.boot(), null);
        MethodHandle implAddReadsMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddReads", MethodType.methodType(Void.TYPE, Module.class));
        config.modules().forEach(rm -> ModuleLayer.boot().findModule(rm.name()).ifPresent(m -> oldBootModules.forEach(brm -> ModuleLayer.boot().findModule(brm.name()).ifPresent(bm -> {
            try {
                implAddReadsMH.invokeWithArguments(m, bm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }))));
    }

    private record ParserData(String module, String packages, String target) {
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ParserData that = (ParserData)obj;
            return Objects.equals(this.module, that.module) && Objects.equals(this.packages, that.packages) && Objects.equals(this.target, that.target);
        }

        @Override
        public String toString() {
            return "ParserData[module=" + this.module + ", packages=" + this.packages + ", target=" + this.target + "]";
        }
    }
}

